(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    135784,       3906]
NotebookOptionsPosition[    131339,       3759]
NotebookOutlinePosition[    131854,       3781]
CellTagsIndexPosition[    131767,       3776]
WindowFrame->Generic*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Needs", "[", 
  RowBox[{
  "\"\<grt`\>\"", ",", "\"\</home/pascal/projects/grtensorm/grt.m\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.475852973903904*^9, 3.475853010758769*^9}, {
  3.475853137371464*^9, 3.47585316446873*^9}, {3.4758532131219397`*^9, 
  3.475853213327142*^9}, {3.475863734322818*^9, 3.475863735374198*^9}}],

Cell[BoxData["\<\"grt: a package to compute Christoffel symbols, Curvature \
tensor, Ricci Tensor, \\nEinstein tensor etc. for arbitrary metrics.\\n\\n(c) \
Pascal M. Vaudrevange (pascal@vaudrevange.com)\\nreleased under GPL\\nVersion \
22. Feb. 2010\"\>"], "Print",
 CellChangeTimes->{
  3.475869231091548*^9, 3.475869460734202*^9, {3.475927820609577*^9, 
   3.475927829677827*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "grt"}]], "Input",
 CellChangeTimes->{{3.475858194583027*^9, 3.4758581960925503`*^9}}],

Cell[BoxData[
 StyleBox["\<\"\\ngrt: a package to compute the Curvature tensor, Ricci \
tensor, \\nEinstein tensor, Christoffel symbols, etc. for arbitrary \
metrics.\\n\\n(c) Pascal M. Vaudrevange (pascal@vaudrevange.com)\\nreleased \
under GPL\\nVersion 22.Feb.2010\\n\\n\\nFirst, load a metric with \\n\\n\t\
LoadMetric[coords, metric]\\n\\nwhere coords is a list of coordinates of \
length ndim and metric is \\nthe ndim \[Times] ndim metric tensor. Note that \
the first coordinate has index 1. \\nFor example, Minkowski space would be\\n\
\\n  coords={t,x,y,z}\\n  \
metric={{1,0,0,0},{0,-1,0,0},{0,0,-1},{0,0,0,-1}}\\n\\nAll objects are \
indexed the following way:\\n\\n\tA[\!\(\*SuperscriptBox[\\\"\[Mu]\\\", \\\"-\
\\\"]\),\!\(\*SubscriptBox[\\\"\[Nu]\\\", \\\"-\\\"]\)] = \
\!\(\*SubscriptBox[SuperscriptBox[\\\"A\\\", \\\"\[Mu]\\\"], \\\"\[Nu]\\\"]\)\
\\n\tA[\!\(\*SubscriptBox[\\\"\[Mu]\\\", \\\"-\\\"]\),\!\(\*SubscriptBox[\\\"\
\[Nu]\\\", \\\"-\\\"]\)] = \!\(\*SubscriptBox[\\\"A\\\", \
\\\"\[Mu]\[Nu]\\\"]\)\\n\tA[\!\(\*SuperscriptBox[\\\"\[Mu]\\\", \\\"-\\\"]\),\
\!\(\*SuperscriptBox[\\\"\[Nu]\\\", \\\"-\\\"]\)] = \
\!\(\*SuperscriptBox[\\\"A\\\", \\\"\[Mu]\[Nu]\\\"]\)\\n\tetc.\\n\\nwhere \
\[Mu],\[Nu] are any numbers between 1, ndim.\\nThe indices of all tensor \
objects MUST indicate whether it is a lower \\nor upper index. For example, \
A[1,1] is illegal. To test for the position \\nof an index, use the supplied \
functions Uppper[] and Lower[].\\n\\nFor the curious: The upper/lower index \
is defined by \\n\\n\tSuperMinus[\[Mu]_Integer]={\[Mu],'u'};\\n\tSubMinus[\
\[Mu]_Integer]={\[Mu],'l'};\\n\\nFor a list of defined symbols, enter \\n\\n\t\
?grt`*\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.475869461838614*^9},
 CellTags->"Info3475851461-6572336"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "grt`*"}]], "Input",
 CellChangeTimes->{{3.475853205822879*^9, 3.4758532084849777`*^9}, {
  3.475853357328846*^9, 3.475853361717588*^9}, {3.4758578329958143`*^9, 
  3.4758578342969627`*^9}, {3.475858286800598*^9, 3.47585828791789*^9}}],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["grt`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["grt`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["Detg",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"Detg", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["Quabla",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"Quabla", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["Show\[CapitalGamma]",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3475851462-5727735", {"Show\[CapitalGamma]", "grt`"}},
          ButtonNote->"grt`"]},
        {
         ButtonBox["g",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"g", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["R",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"R", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["Upper",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"Upper", "grt`"}},
          ButtonNote->"grt`"]},
        {
         ButtonBox["G",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"G", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["RicciScalar",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"RicciScalar", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["ValidP",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"ValidP", "grt`"}},
          ButtonNote->"grt`"]},
        {
         ButtonBox["grt",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"grt", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["ShowCurvatureTensor",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3475851462-5727735", {"ShowCurvatureTensor", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["\[CapitalGamma]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"\[CapitalGamma]", "grt`"}},
          
          ButtonNote->"grt`"]},
        {
         ButtonBox["LoadMetric",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"LoadMetric", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["ShowEinsteinTensor",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3475851462-5727735", {"ShowEinsteinTensor", "grt`"}},
          ButtonNote->"grt`"], ""},
        {
         ButtonBox["Lower",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"Lower", "grt`"}},
          ButtonNote->"grt`"], 
         ButtonBox["ShowRicciTensor",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3475851462-5727735", {"ShowRicciTensor", "grt`"}},
          
          ButtonNote->"grt`"], ""}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.31666666666666665`]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->Automatic]]], "Print", "InfoCell",
 CellChangeTimes->{3.475869463486206*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"coord1", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"metric1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "\[Epsilon]", " ", 
           RowBox[{"\[Psi]", "[", 
            RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ")"}]}], 
       ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "\[Epsilon]", " ", 
            RowBox[{"\[CapitalPhi]", "[", 
             RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ")"}]}], 
        
        RowBox[{
         RowBox[{"a", "[", "t", "]"}], "^", "2"}]}], ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", "\[Epsilon]", " ", 
            RowBox[{"\[CapitalPhi]", "[", 
             RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ")"}]}], 
        " ", 
        RowBox[{
         RowBox[{"a", "[", "t", "]"}], "^", "2"}]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", "\[Epsilon]", " ", 
            RowBox[{"\[CapitalPhi]", "[", 
             RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ")"}]}], 
        
        RowBox[{
         RowBox[{"a", "[", "t", "]"}], "^", "2"}]}]}], "}"}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4758571414331636`*^9, 3.4758571419893103`*^9}, {
  3.475927736549534*^9, 3.475927814909466*^9}, {3.475927909355887*^9, 
  3.475927910062644*^9}, {3.4759310046886797`*^9, 3.475931006430232*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadMetric", "[", 
  RowBox[{"coord1", ",", "metric1"}], "]"}]], "Input",
 CellChangeTimes->{{3.475854762230823*^9, 3.4758547690837603`*^9}, {
  3.47585716908572*^9, 3.4758571707879963`*^9}, {3.4758593238836203`*^9, 
  3.4758593261362333`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SubscriptBox[\\\"g\\\", \\\"\[Mu]\[Nu]\\\"]\\)=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "\[Epsilon]", " ", 
          RowBox[{"\[Psi]", "[", 
           RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], "0", "0", 
        "0"},
       {"0", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"a", "[", "t", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"2", " ", "\[Epsilon]", " ", 
            RowBox[{"\[CapitalPhi]", "[", 
             RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ")"}]}], 
        "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"a", "[", "t", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"2", " ", "\[Epsilon]", " ", 
            RowBox[{"\[CapitalPhi]", "[", 
             RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ")"}]}], 
        "0"},
       {"0", "0", "0", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"a", "[", "t", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"2", " ", "\[Epsilon]", " ", 
            RowBox[{"\[CapitalPhi]", "[", 
             RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["\!\(\*SubscriptBox[\"g\", \"\[Mu]\[Nu]\"]\)=", 
   MatrixForm[{{
     1 - 2 $CellContext`\[Epsilon] $CellContext`\[Psi][$CellContext`t, \
$CellContext`x, $CellContext`y, $CellContext`z], 0, 0, 0}, {
     0, $CellContext`a[$CellContext`t]^2 (-1 - 
       2 $CellContext`\[Epsilon] $CellContext`\[CapitalPhi][$CellContext`t, \
$CellContext`x, $CellContext`y, $CellContext`z]), 0, 0}, {
     0, 0, $CellContext`a[$CellContext`t]^2 (-1 - 
       2 $CellContext`\[Epsilon] $CellContext`\[CapitalPhi][$CellContext`t, \
$CellContext`x, $CellContext`y, $CellContext`z]), 0}, {
     0, 0, 0, $CellContext`a[$CellContext`t]^2 (-1 - 
       2 $CellContext`\[Epsilon] $CellContext`\[CapitalPhi][$CellContext`t, \
$CellContext`x, $CellContext`y, $CellContext`z])}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475927834665696*^9, 3.4759279113855057`*^9, 
  3.475931008293928*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"coordinates = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "}"}]}],
  SequenceForm[
  "coordinates = ", {$CellContext`t, $CellContext`x, $CellContext`y, \
$CellContext`z}],
  Editable->False]], "Print",
 CellChangeTimes->{3.475927834665696*^9, 3.4759279113855057`*^9, 
  3.475931008331626*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"grt`Private`EinsteinTensor", ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   "\[Epsilon]", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.475927840794421*^9, 3.475927891853684*^9}, {
  3.475930990578389*^9, 3.475930994396624*^9}, {3.475931273542169*^9, 
  3.475931284951557*^9}, {3.4759419429337254`*^9, 3.4759419441167994`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        SuperscriptBox[
         RowBox[{"a", "[", "t", "]"}], "2"]], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            SuperscriptBox["\[CapitalPhi]", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["\[CapitalPhi]", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
          RowBox[{
           SuperscriptBox["\[CapitalPhi]", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"a", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["a", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[CapitalPhi]", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], 
         ")"}]}]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Psi]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], 
       RowBox[{"a", "[", "t", "]"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Psi]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], 
       RowBox[{"a", "[", "t", "]"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Psi]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], 
       RowBox[{"a", "[", "t", "]"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Psi]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], 
       RowBox[{"a", "[", "t", "]"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Psi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"a", "[", "t", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Psi]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], 
       RowBox[{"a", "[", "t", "]"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Psi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"a", "[", "t", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Psi]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], 
       RowBox[{"a", "[", "t", "]"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[CapitalPhi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Psi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"a", "[", "t", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "]"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.475927866291959*^9, 3.475927917208456*^9}, {
   3.4759309951986837`*^9, 3.475931013355249*^9}, {3.475931274255732*^9, 
   3.4759312854983273`*^9}, 3.475941944753684*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Show\[CapitalGamma]"], "Input",
 CellChangeTimes->{{3.475868583077599*^9, 3.475868585519526*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"2", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", "[", "t", "]"}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 1], 2, 2], 
   "=", $CellContext`a[$CellContext`t] 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.4758694673544617`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"3", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", "[", "t", "]"}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 1], 3, 3], 
   "=", $CellContext`a[$CellContext`t] 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.475869467398383*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"4", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", "[", "t", "]"}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 1], 4, 4], 
   "=", $CellContext`a[$CellContext`t] 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.475869467451942*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","2"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 2], 1, 2], 
   "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.4758694675249157`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","2"},
      "Superscript"], ")"}], 
    RowBox[{"2", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 2], 2, 1], 
   "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.475869467587825*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","3"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 3], 1, 3], 
   "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.475869467625386*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","3"},
      "Superscript"], ")"}], 
    RowBox[{"3", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 3], 3, 1], 
   "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.475869467741932*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","4"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 4], 1, 4], 
   "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.475869467810678*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"\[CapitalGamma]\"","4"},
      "Superscript"], ")"}], 
    RowBox[{"4", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["\[CapitalGamma]", 4], 4, 1], 
   "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[1][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868697225985*^9, 3.47586875318601*^9, 
  3.475868958355589*^9, 3.4758690189381037`*^9, 3.4758690501427317`*^9, 
  3.475869129033925*^9, 3.4758691714326344`*^9, 3.475869236464362*^9, 
  3.475869467891966*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["ShowCurvatureTensor"], "Input",
 CellChangeTimes->{{3.475868981156509*^9, 3.475868986522889*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "2", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", "[", "t", "]"}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 1], 1, 2, 2], "=", $CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869468706477*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "3", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", "[", "t", "]"}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 1], 1, 3, 3], "=", $CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.4758694687409563`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "4", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", "[", "t", "]"}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 1], 1, 4, 4], "=", $CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869468810117*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"2", ",", "1", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"a", "[", "t", "]"}]}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 1], 2, 1, 2], "=", -$CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869468878407*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"3", ",", "1", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"a", "[", "t", "]"}]}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 1], 3, 1, 3], "=", -$CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869468947391*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","1"},
      "Superscript"], ")"}], 
    RowBox[{"4", ",", "1", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"a", "[", "t", "]"}]}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 1], 4, 1, 4], "=", -$CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869469012966*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","2"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "2", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["R", 2], 1, 2, 1], "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869469122287*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","2"},
      "Superscript"], ")"}], 
    RowBox[{"2", ",", "1", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], 
     RowBox[{"a", "[", "t", "]"}]]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 2], 2, 1, 1], "=", -$CellContext`a[$CellContext`t]^(-1) 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869469192137*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","2"},
      "Superscript"], ")"}], 
    RowBox[{"2", ",", "3", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}],
  SequenceForm[
   Subscript[
    Superscript["R", 2], 2, 3, 3], "=", 
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.4758694692537603`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","2"},
      "Superscript"], ")"}], 
    RowBox[{"2", ",", "4", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}],
  SequenceForm[
   Subscript[
    Superscript["R", 2], 2, 4, 4], "=", 
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.4758694693248167`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","2"},
      "Superscript"], ")"}], 
    RowBox[{"3", ",", "2", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 2], 3, 2, 3], "=", -
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869469398541*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","2"},
      "Superscript"], ")"}], 
    RowBox[{"4", ",", "2", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 2], 4, 2, 4], "=", -
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869469457961*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","3"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "3", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["R", 3], 1, 3, 1], "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869469525424*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","3"},
      "Superscript"], ")"}], 
    RowBox[{"2", ",", "3", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 3], 2, 3, 2], "=", -
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.4758694695789137`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","3"},
      "Superscript"], ")"}], 
    RowBox[{"3", ",", "1", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], 
     RowBox[{"a", "[", "t", "]"}]]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 3], 3, 1, 1], "=", -$CellContext`a[$CellContext`t]^(-1) 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869469656786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","3"},
      "Superscript"], ")"}], 
    RowBox[{"3", ",", "2", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}],
  SequenceForm[
   Subscript[
    Superscript["R", 3], 3, 2, 2], "=", 
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869469806367*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","3"},
      "Superscript"], ")"}], 
    RowBox[{"3", ",", "4", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}],
  SequenceForm[
   Subscript[
    Superscript["R", 3], 3, 4, 4], "=", 
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.47586946988708*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","3"},
      "Superscript"], ")"}], 
    RowBox[{"4", ",", "3", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 3], 4, 3, 4], "=", -
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.4758694699759007`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","4"},
      "Superscript"], ")"}], 
    RowBox[{"1", ",", "4", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript[
    Superscript["R", 4], 1, 4, 1], "=", $CellContext`a[$CellContext`t]^(-1) 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869470132523*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","4"},
      "Superscript"], ")"}], 
    RowBox[{"2", ",", "4", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 4], 2, 4, 2], "=", -
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.4758694702093277`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","4"},
      "Superscript"], ")"}], 
    RowBox[{"3", ",", "4", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 4], 3, 4, 3], "=", -
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.4758694702684793`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","4"},
      "Superscript"], ")"}], 
    RowBox[{"4", ",", "1", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], 
     RowBox[{"a", "[", "t", "]"}]]}]}],
  SequenceForm[
   Subscript[
    Superscript["R", 4], 4, 1, 1], "=", -$CellContext`a[$CellContext`t]^(-1) 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869470406769*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","4"},
      "Superscript"], ")"}], 
    RowBox[{"4", ",", "2", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}],
  SequenceForm[
   Subscript[
    Superscript["R", 4], 4, 2, 2], "=", 
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.475869470467104*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox[
    RowBox[{"(", 
     TemplateBox[{"\"R\"","4"},
      "Superscript"], ")"}], 
    RowBox[{"4", ",", "3", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}],
  SequenceForm[
   Subscript[
    Superscript["R", 4], 4, 3, 3], "=", 
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475868988180925*^9, 3.4758690206360607`*^9, 
  3.47586905227949*^9, 3.475869130516841*^9, 3.475869172942461*^9, 
  3.475869237414657*^9, 3.4758694705365*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["ShowRicciTensor"], "Input",
 CellChangeTimes->{{3.4758694711962137`*^9, 3.475869474648355*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"R\"\>", 
    RowBox[{"1", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], 
    RowBox[{"a", "[", "t", "]"}]]}],
  SequenceForm[
   Subscript["R", 1, 1], "=", 3 $CellContext`a[$CellContext`t]^(-1) 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475869475343981*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"R\"\>", 
    RowBox[{"2", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"]}], "-", 
    RowBox[{
     RowBox[{"a", "[", "t", "]"}], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}],
  SequenceForm[
   Subscript["R", 2, 2], 
   "=", (-2) 
    Derivative[
      1][$CellContext`a][$CellContext`t]^2 - $CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4758694754572163`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"R\"\>", 
    RowBox[{"3", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"]}], "-", 
    RowBox[{
     RowBox[{"a", "[", "t", "]"}], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}],
  SequenceForm[
   Subscript["R", 3, 3], 
   "=", (-2) 
    Derivative[
      1][$CellContext`a][$CellContext`t]^2 - $CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475869475532325*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"R\"\>", 
    RowBox[{"4", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"]}], "-", 
    RowBox[{
     RowBox[{"a", "[", "t", "]"}], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}],
  SequenceForm[
   Subscript["R", 4, 4], 
   "=", (-2) 
    Derivative[
      1][$CellContext`a][$CellContext`t]^2 - $CellContext`a[$CellContext`t] 
   Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475869475598414*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["ShowEinsteinTensor"], "Input",
 CellChangeTimes->{{3.475869476700759*^9, 3.475869479087689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"R\"\>", 
    RowBox[{"1", ",", "1"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "2"]}], 
     SuperscriptBox[
      RowBox[{"a", "[", "t", "]"}], "2"]]}]}],
  SequenceForm[
   Subscript["R", 1, 1], "=", (-3) $CellContext`a[$CellContext`t]^(-2) 
   Derivative[1][$CellContext`a][$CellContext`t]^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.475869479578747*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"R\"\>", 
    RowBox[{"2", ",", "2"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
    RowBox[{"2", " ", 
     RowBox[{"a", "[", "t", "]"}], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}],
  SequenceForm[
   Subscript["R", 2, 2], "=", Derivative[1][$CellContext`a][$CellContext`t]^2 + 
   2 $CellContext`a[$CellContext`t] 
    Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4758694796954927`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"R\"\>", 
    RowBox[{"3", ",", "3"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
    RowBox[{"2", " ", 
     RowBox[{"a", "[", "t", "]"}], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}],
  SequenceForm[
   Subscript["R", 3, 3], "=", Derivative[1][$CellContext`a][$CellContext`t]^2 + 
   2 $CellContext`a[$CellContext`t] 
    Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4758694797609386`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"R\"\>", 
    RowBox[{"4", ",", "4"}]], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
    RowBox[{"2", " ", 
     RowBox[{"a", "[", "t", "]"}], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}],
  SequenceForm[
   Subscript["R", 4, 4], "=", Derivative[1][$CellContext`a][$CellContext`t]^2 + 
   2 $CellContext`a[$CellContext`t] 
    Derivative[2][$CellContext`a][$CellContext`t]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475869479861305*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["RicciScalar"], "Input",
 CellChangeTimes->{{3.475865923650766*^9, 3.475865923756081*^9}, {
  3.475866295891473*^9, 3.4758662979222927`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"6", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
     RowBox[{
      RowBox[{"a", "[", "t", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"a", "[", "t", "]"}], "2"]]], "Output",
 CellChangeTimes->{3.47586623597093*^9, 3.475866298460227*^9, 
  3.475866693858852*^9, 3.475866733462986*^9, 3.4758668102289877`*^9, 
  3.475866898242564*^9, 3.475868246990375*^9, 3.4758694987802753`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quabla", "[", 
  RowBox[{"f", "[", "t", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.475861708799193*^9, 3.475861712381302*^9}, {
  3.475861984846142*^9, 3.4758619866675987`*^9}, {3.4758620330629597`*^9, 
  3.475862034418693*^9}, {3.4758621399752417`*^9, 3.475862140899948*^9}, {
  3.475862402745708*^9, 3.475862403511404*^9}, {3.475864360196125*^9, 
  3.4758643620267067`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], 
   RowBox[{"a", "[", "t", "]"}]], "+", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "t", "]"}]}]], "Output",
 CellChangeTimes->{
  3.4758617127011747`*^9, 3.475861904663549*^9, 3.4758619869534073`*^9, 
   3.475862035517878*^9, 3.47586207967682*^9, 3.4758621413697653`*^9, 
   3.4758623457938833`*^9, {3.475862400354456*^9, 3.4758624038714743`*^9}, 
   3.475863764626223*^9, 3.47586379987193*^9, 3.475863877909164*^9, 
   3.47586436243559*^9, 3.475864519287291*^9, 3.475864617298191*^9, 
   3.475864692422018*^9, 3.475864876867015*^9, 3.4758649444382353`*^9, 
   3.475865064803895*^9, 3.4758651858805647`*^9, 3.4758654180615807`*^9, 
   3.475865504047368*^9, 3.4758656676818447`*^9, 3.4758657776613207`*^9, 
   3.475866138325622*^9, 3.475866695281674*^9, 3.4758668992930737`*^9, 
   3.4758682499548483`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tanmnayCoords", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tanmay", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"a", "[", "t", "]"}], "2"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"t", ",", "r"}], "]"}]}], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"a", "[", "t", "]"}], "2"]}], 
        RowBox[{"h1", "[", 
         RowBox[{"t", ",", "r"}], "]"}]}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"a", "[", "t", "]"}], "2"], 
        RowBox[{"h2", "[", 
         RowBox[{"t", ",", "r"}], "]"}], " ", 
        SuperscriptBox["r", "2"]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"a", "[", "t", "]"}], 
         RowBox[{"2", " "}]], 
        RowBox[{"h2", "[", 
         RowBox[{"t", ",", "r"}], "]"}], " ", 
        SuperscriptBox["r", "2"], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"2", " "}]]}]}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.475862635251892*^9, 3.475862773190689*^9}, {
  3.475862807872308*^9, 3.47586285155807*^9}, {3.475866918426136*^9, 
  3.4758669193261023`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}]], "Output",
 CellChangeTimes->{{3.475862791163342*^9, 3.475862816743001*^9}, 
   3.475862871839168*^9, 3.475862944821056*^9, 3.4758633704559383`*^9, 
   3.4758648877432547`*^9, 3.475866389511821*^9, 3.475866841570951*^9, 
   3.475866906130149*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"a", "[", "t", "]"}], "2"], " ", 
      RowBox[{"f", "[", 
       RowBox[{"t", ",", "r"}], "]"}]}], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"a", "[", "t", "]"}], "2"]}], " ", 
      RowBox[{"h1", "[", 
       RowBox[{"t", ",", "r"}], "]"}]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", "t", "]"}], "2"], " ", 
      RowBox[{"h2", "[", 
       RowBox[{"t", ",", "r"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", "t", "]"}], "2"], " ", 
      RowBox[{"h2", "[", 
       RowBox[{"t", ",", "r"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.475862791163342*^9, 3.475862816743001*^9}, 
   3.475862871839168*^9, 3.475862944821056*^9, 3.4758633704559383`*^9, 
   3.4758648877432547`*^9, 3.475866389511821*^9, 3.475866841570951*^9, 
   3.4758669061854553`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadMetric", "[", 
  RowBox[{"tanmnayCoords", ",", "tanmay"}], "]"}]], "Input",
 CellChangeTimes->{{3.475862823143914*^9, 3.475862833269244*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SubscriptBox[\\\"g\\\", \\\"\[Mu]\[Nu]\\\"]\\)=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"a", "[", "t", "]"}], "2"], " ", 
         RowBox[{"f", "[", 
          RowBox[{"t", ",", "r"}], "]"}]}], "0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"a", "[", "t", "]"}], "2"]}], " ", 
         RowBox[{"h1", "[", 
          RowBox[{"t", ",", "r"}], "]"}]}], "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"a", "[", "t", "]"}], "2"], " ", 
         RowBox[{"h2", "[", 
          RowBox[{"t", ",", "r"}], "]"}]}], "0"},
       {"0", "0", "0", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"a", "[", "t", "]"}], "2"], " ", 
         RowBox[{"h2", "[", 
          RowBox[{"t", ",", "r"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["\!\(\*SubscriptBox[\"g\", \"\[Mu]\[Nu]\"]\)=", 
   MatrixForm[{{$CellContext`a[$CellContext`t]^2 \
$CellContext`f[$CellContext`t, $CellContext`r], 0, 0, 0}, {
     0, -$CellContext`a[$CellContext`t]^2 $CellContext`h1[$CellContext`t, \
$CellContext`r], 0, 0}, {
     0, 0, $CellContext`r^2 $CellContext`a[$CellContext`t]^2 \
$CellContext`h2[$CellContext`t, $CellContext`r], 0}, {
     0, 0, 0, $CellContext`r^2 $CellContext`a[$CellContext`t]^2 \
$CellContext`h2[$CellContext`t, $CellContext`r] 
      Sin[$CellContext`\[Theta]]^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4758648893224907`*^9, 3.4758663907990313`*^9, 
  3.475866842741189*^9, 3.4758669070096617`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"coordinates = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}]}],
  SequenceForm[
  "coordinates = ", {$CellContext`t, $CellContext`r, $CellContext`\[Theta], \
$CellContext`\[Phi]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.4758648893224907`*^9, 3.4758663907990313`*^9, 
  3.475866842741189*^9, 3.475866907059744*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["RicciScalar"], "Input",
 CellChangeTimes->{{3.4758629504279623`*^9, 3.475862952194886*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"6", " ", 
     SuperscriptBox["r", "2"], " ", 
     RowBox[{"h1", "[", 
      RowBox[{"t", ",", "r"}], "]"}], " ", 
     RowBox[{"h2", "[", 
      RowBox[{"t", ",", "r"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"h1", "[", 
          RowBox[{"t", ",", "r"}], "]"}]}], " ", 
        RowBox[{"h2", "[", 
         RowBox[{"t", ",", "r"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "r"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"t", ",", "r"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"h2", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["a", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "r"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"h1", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["a", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "+", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], " ", 
              RowBox[{
               SuperscriptBox["h2", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}], "-", 
    RowBox[{
     RowBox[{"a", "[", "t", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"f", "[", 
          RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"h1", "[", 
             RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
           RowBox[{"h2", "[", 
            RowBox[{"t", ",", "r"}], "]"}]}], "-", 
          RowBox[{"2", " ", "r", " ", 
           RowBox[{"h2", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["h1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}]}], "+", 
             RowBox[{"r", " ", 
              RowBox[{
               SuperscriptBox["h2", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"h1", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox[
               RowBox[{"h2", "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"]}], "-", 
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h2", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"]}], "+", 
             RowBox[{"4", " ", "r", " ", 
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", 
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}], "+", 
                RowBox[{"r", " ", 
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"h1", "[", 
         RowBox[{"t", ",", "r"}], "]"}], " ", 
        RowBox[{"h2", "[", 
         RowBox[{"t", ",", "r"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"h2", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"]}], "+", 
             RowBox[{
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["h1", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"h1", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"r", " ", 
        RowBox[{"f", "[", 
         RowBox[{"t", ",", "r"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"r", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", 
             RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "r"}], "]"}]}], " ", 
              RowBox[{
               SuperscriptBox["h1", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}], "+", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["h1", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}], "2"]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"h1", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"h2", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}], "-", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}], "+", 
                RowBox[{"r", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}], "-", 
                RowBox[{"r", " ", 
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"2", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"r", " ", 
           SuperscriptBox[
            RowBox[{"h1", "[", 
             RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["h2", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}], "2"], "-", 
             RowBox[{"4", " ", 
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["h2", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"2", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"], " ", 
    SuperscriptBox[
     RowBox[{"a", "[", "t", "]"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"f", "[", 
      RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"h1", "[", 
      RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"h2", "[", 
      RowBox[{"t", ",", "r"}], "]"}], "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.475862954994657*^9, 3.475864893854966*^9, 3.475866392812233*^9, {
   3.475866880455146*^9, 3.4758669099348583`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"G", "[", 
    RowBox[{
     SubscriptBox["a", "-"], ",", 
     SubscriptBox["b", "-"]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758628755172157`*^9, 3.4758629096875772`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"t", ",", "r"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"h1", "[", 
              RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
            RowBox[{"h2", "[", 
             RowBox[{"t", ",", "r"}], "]"}]}], "-", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"h2", "[", 
             RowBox[{"t", ",", "r"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["h1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "r"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"h2", "[", 
                RowBox[{"t", ",", "r"}], "]"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{
                SuperscriptBox["h2", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"h1", "[", 
             RowBox[{"t", ",", "r"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox[
                RowBox[{"h2", "[", 
                 RowBox[{"t", ",", "r"}], "]"}], "2"]}], "-", 
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h2", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}], "2"]}], "+", 
              RowBox[{"4", " ", "r", " ", 
               RowBox[{"h2", "[", 
                RowBox[{"t", ",", "r"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  RowBox[{
                   SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "r"}], "]"}]}], "+", 
                 RowBox[{"r", " ", 
                  RowBox[{
                   SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"h1", "[", 
          RowBox[{"t", ",", "r"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "r"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"h2", "[", 
             RowBox[{"t", ",", "r"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["h1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "r"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"h1", "[", 
             RowBox[{"t", ",", "r"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["h2", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"h1", "[", 
          RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", 
          RowBox[{"t", ",", "r"}], "]"}], "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"h1", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{"h2", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "r"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
             RowBox[{
              SuperscriptBox["h1", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"t", ",", "r"}], "]"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"h1", "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h2", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h2", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"t", ",", "r"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"h2", "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{
                 SuperscriptBox["h2", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["h1", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"h1", "[", 
                 RowBox[{"t", ",", "r"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "r"}], "]"}], "+", 
                  RowBox[{"r", " ", 
                   RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"f", "[", 
          RowBox[{"t", ",", "r"}], "]"}], " ", 
         RowBox[{"h1", "[", 
          RowBox[{"t", ",", "r"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", 
           RowBox[{"t", ",", "r"}], "]"}], "2"]}], ")"}]}]}], ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"h1", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{"h2", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "r"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
             RowBox[{
              SuperscriptBox["h1", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"t", ",", "r"}], "]"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"h1", "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h2", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h2", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"t", ",", "r"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"h2", "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{
                 SuperscriptBox["h2", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["h1", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"h1", "[", 
                 RowBox[{"t", ",", "r"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "r"}], "]"}], "+", 
                  RowBox[{"r", " ", 
                   RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"f", "[", 
          RowBox[{"t", ",", "r"}], "]"}], " ", 
         RowBox[{"h1", "[", 
          RowBox[{"t", ",", "r"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", 
           RowBox[{"t", ",", "r"}], "]"}], "2"]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"f", "[", 
            RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"h1", "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             RowBox[{"h2", "[", 
              RowBox[{"t", ",", "r"}], "]"}]}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"h2", "[", 
                 RowBox[{"t", ",", "r"}], "]"}]}], "+", 
               RowBox[{"r", " ", 
                RowBox[{
                 SuperscriptBox["h2", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], 
         "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"h1", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{"h2", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "r"}], "]"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"f", "[", 
           RowBox[{"t", ",", "r"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"t", ",", "r"}], "]"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"h1", "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["h2", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}], "2"]}], "+", 
            RowBox[{"2", " ", "r", " ", 
             RowBox[{"h2", "[", 
              RowBox[{"t", ",", "r"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["h2", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"h1", "[", 
                 RowBox[{"t", ",", "r"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["h2", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"2", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", 
           RowBox[{"t", ",", "r"}], "]"}], "2"]}], ")"}]}]}], ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox[
             RowBox[{"f", "[", 
              RowBox[{"t", ",", "r"}], "]"}], "2"]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"h2", "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
              RowBox[{
               SuperscriptBox["h1", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}], "+", 
             RowBox[{"r", " ", 
              RowBox[{"h1", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h2", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"]}], "+", 
             RowBox[{
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"h1", "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"r", " ", 
           RowBox[{"h1", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"h2", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "r"}], "]"}], "2"]}], "+", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"h1", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["h2", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", " ", 
              SuperscriptBox[
               RowBox[{"h2", "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "r"}], "]"}]}], " ", 
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}], "+", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], "2"]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"h1", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}], "-", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["h1", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"h2", "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}], "-", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["h1", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"2", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"r", " ", 
              SuperscriptBox[
               RowBox[{"h1", "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], "2"], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"h2", "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"2", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", 
          RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"h1", "[", 
          RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
        RowBox[{"h2", "[", 
         RowBox[{"t", ",", "r"}], "]"}]}], ")"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox[
             RowBox[{"f", "[", 
              RowBox[{"t", ",", "r"}], "]"}], "2"]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"h2", "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
              RowBox[{
               SuperscriptBox["h1", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}], "+", 
             RowBox[{"r", " ", 
              RowBox[{"h1", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h2", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"]}], "+", 
             RowBox[{
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"h1", "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"r", " ", 
           RowBox[{"h1", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"h2", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "r"}], "]"}], "2"]}], "+", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"h1", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["h2", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"t", ",", "r"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", " ", 
              SuperscriptBox[
               RowBox[{"h2", "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "r"}], "]"}]}], " ", 
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}], "+", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], "2"]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"h1", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"h2", "[", 
               RowBox[{"t", ",", "r"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}], "-", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["h1", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h2", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"h2", "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}], "-", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["h1", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"2", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"r", " ", 
              SuperscriptBox[
               RowBox[{"h1", "[", 
                RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}], "2"], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"h2", "[", 
                  RowBox[{"t", ",", "r"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h2", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"2", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "r"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", 
          RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"h1", "[", 
          RowBox[{"t", ",", "r"}], "]"}], "2"], " ", 
        RowBox[{"h2", "[", 
         RowBox[{"t", ",", "r"}], "]"}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.47586490962527*^9, 3.475866847434585*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{
   SubscriptBox["1", "-"], ",", 
   SubscriptBox["1", "-"]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758631594917297`*^9, 3.4758631661823883`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error in \\!\\(\\*SubscriptBox[\\\"g\\\", \
\\\"\[Mu]\[Nu]\\\"]\\): \[Mu]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"l\"\>"}], "}"}], 
   "\[InvisibleSpace]", "\<\", \[Nu]=\"\>", "\[InvisibleSpace]", 
   SuperscriptBox["grt`Private`\[Alpha]$513", "-"]}],
  SequenceForm[
  "Error in \!\(\*SubscriptBox[\"g\", \"\[Mu]\[Nu]\"]\): \[Mu]=", {1, "l"}, 
   ", \[Nu]=", 
   SuperMinus[grt`Private`\[Alpha]$513]],
  Editable->False]], "Print",
 CellChangeTimes->{3.475863166419011*^9, 3.475863390050544*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.475863168981297*^9, 3.4758633917567043`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.47586277969557*^9, 3.475862785479828*^9}, {
  3.4758628575046787`*^9, 3.47586286836926*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "=", 
  SuperscriptBox["x", "2"]}]], "Input",
 CellChangeTimes->{{3.475863529048129*^9, 3.4758635324022303`*^9}}],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 CellChangeTimes->{3.475863532679193*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellChangeTimes->{{3.4758635332892513`*^9, 3.475863538784663*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 CellChangeTimes->{{3.475863535869274*^9, 3.475863539100027*^9}}]
}, Open  ]]
},
WindowSize->{1302, 744},
WindowMargins->{{37, Automatic}, {98, Automatic}},
ShowSelection->True,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (November 11, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3475851461-6572336"->{
  Cell[1461, 46, 1800, 26, 827, "Print",
   CellTags->"Info3475851461-6572336"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3475851461-6572336", 131662, 3770}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[568, 22, 353, 7, 32, "Input"],
Cell[924, 31, 383, 6, 145, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1344, 42, 114, 2, 32, "Input"],
Cell[1461, 46, 1800, 26, 827, "Print",
 CellTags->"Info3475851461-6572336"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3298, 77, 263, 4, 32, "Input"],
Cell[3564, 83, 3680, 99, 193, "Print"]
}, Open  ]],
Cell[7259, 185, 2030, 58, 121, "Input"],
Cell[CellGroupData[{
Cell[9314, 247, 268, 5, 32, "Input"],
Cell[CellGroupData[{
Cell[9607, 256, 2919, 72, 79, "Print"],
Cell[12529, 330, 392, 10, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12970, 346, 480, 10, 32, "Input"],
Cell[13453, 358, 21359, 602, 376, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34849, 965, 111, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[34985, 970, 832, 23, 29, "Print"],
Cell[35820, 995, 830, 23, 29, "Print"],
Cell[36653, 1020, 830, 23, 29, "Print"],
Cell[37486, 1045, 835, 23, 44, "Print"],
Cell[38324, 1070, 833, 23, 44, "Print"],
Cell[39160, 1095, 833, 23, 44, "Print"],
Cell[39996, 1120, 833, 23, 44, "Print"],
Cell[40832, 1145, 833, 23, 44, "Print"],
Cell[41668, 1170, 833, 23, 44, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42550, 1199, 111, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[42686, 1204, 768, 21, 29, "Print"],
Cell[43457, 1227, 770, 21, 29, "Print"],
Cell[44230, 1250, 768, 21, 29, "Print"],
Cell[45001, 1273, 790, 22, 29, "Print"],
Cell[45794, 1297, 790, 22, 29, "Print"],
Cell[46587, 1321, 790, 22, 29, "Print"],
Cell[47380, 1345, 771, 21, 44, "Print"],
Cell[48154, 1368, 796, 22, 44, "Print"],
Cell[48953, 1392, 704, 20, 29, "Print"],
Cell[49660, 1414, 704, 20, 29, "Print"],
Cell[50367, 1436, 726, 21, 29, "Print"],
Cell[51096, 1459, 726, 21, 29, "Print"],
Cell[51825, 1482, 771, 21, 44, "Print"],
Cell[52599, 1505, 728, 21, 29, "Print"],
Cell[53330, 1528, 796, 22, 44, "Print"],
Cell[54129, 1552, 702, 20, 29, "Print"],
Cell[54834, 1574, 701, 20, 29, "Print"],
Cell[55538, 1596, 728, 21, 29, "Print"],
Cell[56269, 1619, 771, 21, 44, "Print"],
Cell[57043, 1642, 728, 21, 29, "Print"],
Cell[57774, 1665, 728, 21, 29, "Print"],
Cell[58505, 1688, 796, 22, 44, "Print"],
Cell[59304, 1712, 702, 20, 29, "Print"],
Cell[60009, 1734, 700, 20, 29, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60758, 1760, 109, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[60892, 1765, 561, 16, 44, "Print"],
Cell[61456, 1783, 804, 25, 26, "Print"],
Cell[62263, 1810, 802, 25, 26, "Print"],
Cell[63068, 1837, 802, 25, 26, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63919, 1868, 110, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[64054, 1873, 642, 19, 46, "Print"],
Cell[64699, 1894, 750, 21, 26, "Print"],
Cell[65452, 1917, 750, 21, 26, "Print"],
Cell[66205, 1940, 748, 21, 26, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67002, 1967, 154, 2, 32, "Input"],
Cell[67159, 1971, 673, 18, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67869, 1994, 403, 7, 32, "Input"],
Cell[68275, 2003, 1119, 24, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69431, 2032, 1622, 48, 77, "Input"],
Cell[71056, 2082, 341, 6, 31, "Output"],
Cell[71400, 2090, 1386, 41, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72823, 2136, 169, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[73017, 2143, 2355, 60, 81, "Print"],
Cell[75375, 2205, 440, 10, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75864, 2221, 105, 1, 32, "Input"],
Cell[75972, 2224, 13263, 373, 345, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89272, 2602, 383, 11, 32, "Input"],
Cell[89658, 2615, 39887, 1081, 1030, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129582, 3701, 193, 5, 32, "Input"],
Cell[129778, 3708, 578, 13, 24, "Print"],
Cell[130359, 3723, 101, 1, 31, "Output"]
}, Open  ]],
Cell[130475, 3727, 141, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[130641, 3733, 169, 4, 32, "Input"],
Cell[130813, 3739, 93, 2, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130943, 3746, 131, 2, 32, "Input"],
Cell[131077, 3750, 246, 6, 33, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
